import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Route, Switch} from "react-router-dom";
import UsersList from "./scenes/UsersList";
import Create from "./scenes/Create/Create";
import Edit from "./scenes/Edit/Edit";
import Detail from "./scenes/Detail/Detail";

export default class UsersScene extends Component {

    constructor(props) {
        super(props);
    }

    render() {
        const {match} = this.props;

        return (<Switch>
            <Route path={match.url + "/create"} component={Create} />
            <Route path={match.url + "/:id/edit"} component={Edit} />
            <Route path={match.url + "/:id"} component={Detail} />
            <Route path={match.url + "/"} component={UsersList} />
        </Switch>);
    }
}

UsersScene.defaultProps = {};

UsersScene.propTypes = {};